/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderDynamicTank
extends MekanismTileEntityRenderer<TileEntityDynamicTank> {
    public RenderDynamicTank(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityDynamicTank tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        RenderData data;
        TankMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (TankMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && (data = this.getRenderData(multiblock)) != null) {
            data.location = multiblock.renderLocation;
            data.height = multiblock.height() - 2;
            data.length = multiblock.length();
            data.width = multiblock.width();
            matrix.m_85836_();
            VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
            BlockPos pos = tile.m_58899_();
            matrix.m_85837_((double)(data.location.m_123341_() - pos.m_123341_()), (double)(data.location.m_123342_() - pos.m_123342_()), (double)(data.location.m_123343_() - pos.m_123343_()));
            int glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
            MekanismRenderer.Model3D model = ModelRenderer.getModel(data, multiblock.prevScale);
            MekanismRenderer.renderObject(model, matrix, buffer, data.getColorARGB(multiblock.prevScale), glow, overlayLight, this.getFaceDisplay(data, model));
            matrix.m_85849_();
            if (data instanceof FluidRenderData) {
                FluidRenderData fluidRenderData = (FluidRenderData)data;
                MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, fluidRenderData, pos, glow, overlayLight, this.isInsideMultiblock(data));
            }
        }
    }

    @Nullable
    private RenderData getRenderData(TankMultiblockData multiblock) {
        return switch (multiblock.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> new FluidRenderData(multiblock.getFluidTank().getFluid());
            case MergedTank.CurrentType.GAS -> new ChemicalRenderData.GasRenderData((GasStack)multiblock.getGasTank().getStack());
            case MergedTank.CurrentType.INFUSION -> new ChemicalRenderData.InfusionRenderData((InfusionStack)multiblock.getInfusionTank().getStack());
            case MergedTank.CurrentType.PIGMENT -> new ChemicalRenderData.PigmentRenderData((PigmentStack)multiblock.getPigmentTank().getStack());
            case MergedTank.CurrentType.SLURRY -> new ChemicalRenderData.SlurryRenderData((SlurryStack)multiblock.getSlurryTank().getStack());
            default -> null;
        };
    }

    @Override
    protected String getProfilerSection() {
        return "dynamicTank";
    }

    public boolean shouldRenderOffScreen(TileEntityDynamicTank tile) {
        if (tile.isMaster()) {
            TankMultiblockData multiblock = (TankMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && !multiblock.isEmpty() && multiblock.renderLocation != null;
        }
        return false;
    }
}

